{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 05.09.98 - 21:43:59 $                                        =}
{========================================================================}
unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMDSMix, ExtCtrls, StdCtrls, MMObj, MMDIBCv, MMLevel, MMDSPObj, MMWave,
  MMCCon, MMDSCon, Buttons, MMSlider, MMWheel, MMCstDlg;

type
  TForm1 = class(TForm)
    FileBtn: TButton;
    ResetBtn: TButton;
    MMDSChannelConnector1: TMMDSChannelConnector;
    MMDSMixChannel1: TMMDSMixChannel;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    LoopCheck: TCheckBox;
    Bevel1: TBevel;
    StartBtn: TButton;
    StopBtn: TButton;
    Mixer: TMMDSWaveMixer;
    FreqSlider: TMMSlider;
    PlayBtn1: TButton;
    VolSlider: TMMSlider;
    Label1: TLabel;
    Label2: TLabel;
    MuteCheck: TCheckBox;
    PanWheel: TMMWheel;
    Timer1: TTimer;
    MMWaveOpenDialog1: TMMWaveOpenDialog;
    Button1: TButton;
    Button2: TButton;
    MMDSChannelConnector2: TMMDSChannelConnector;
    MMDSMixChannel2: TMMDSMixChannel;
    MMLevel3: TMMLevel;
    MMLevel4: TMMLevel;
    CheckBox1: TCheckBox;
    MMSlider1: TMMSlider;
    PlayBtn2: TButton;
    MMSlider2: TMMSlider;
    Label3: TLabel;
    Label4: TLabel;
    CheckBox2: TCheckBox;
    MMWheel1: TMMWheel;
    Button4: TButton;
    Button5: TButton;
    MMDSChannelConnector3: TMMDSChannelConnector;
    MMDSMixChannel3: TMMDSMixChannel;
    MMLevel5: TMMLevel;
    MMLevel6: TMMLevel;
    CheckBox3: TCheckBox;
    MMSlider3: TMMSlider;
    PlayBtn3: TButton;
    MMSlider4: TMMSlider;
    Label5: TLabel;
    Label6: TLabel;
    CheckBox4: TCheckBox;
    MMWheel2: TMMWheel;
    Button7: TButton;
    Button8: TButton;
    MMDSChannelConnector4: TMMDSChannelConnector;
    MMDSMixChannel4: TMMDSMixChannel;
    MMLevel7: TMMLevel;
    MMLevel8: TMMLevel;
    CheckBox5: TCheckBox;
    MMSlider5: TMMSlider;
    PlayBtn4: TButton;
    MMSlider6: TMMSlider;
    Label7: TLabel;
    Label8: TLabel;
    CheckBox6: TCheckBox;
    MMWheel3: TMMWheel;
    Time1: TLabel;
    Time2: TLabel;
    Time3: TLabel;
    Time4: TLabel;
    procedure PlayBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LoopCheckClick(Sender: TObject);
    procedure MuteCheckClick(Sender: TObject);
    procedure FileBtnClick(Sender: TObject);
    procedure ResetBtnClick(Sender: TObject);
    procedure FreqSliderChange(Sender: TObject);
    procedure VolSliderChange(Sender: TObject);
    procedure PanWheelChange(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure StartBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
  private
    FChannels: array[1..4] of TMMDSMixChannel;
    FTimeLabel: array[1..4] of TLabel;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  FChannels[1] := MMDSMixChannel1;
  FChannels[2] := MMDSMixChannel2;
  FChannels[3] := MMDSMixChannel3;
  FChannels[4] := MMDSMixChannel4;
  FTimeLabel[1] := Time1;
  FTimeLabel[2] := Time2;
  FTimeLabel[3] := Time3;
  FTimeLabel[4] := Time4;
end;

 // Channel Interface

procedure TForm1.PlayBtn1Click(Sender: TObject);
begin
  if Mixer.Opened then
    with FChannels[(Sender as TComponent).Tag] do
      if SoundBuffer.Playing then Stop else Play;
end;

procedure TForm1.LoopCheckClick(Sender: TObject);
begin
  with FChannels[(Sender as TComponent).Tag] do
    Looping := (Sender as TCheckBox).Checked
end;

procedure TForm1.MuteCheckClick(Sender: TObject);
begin
  with FChannels[(Sender as TComponent).Tag] do
    Muted := (Sender as TCheckBox).Checked
end;

procedure TForm1.FileBtnClick(Sender: TObject);
begin
  with FChannels[(Sender as TComponent).Tag] do
  try
    MMWaveOpenDialog1.FileName := Wave.FileName;
    if MMWaveOpenDialog1.Execute then
    begin
      Stop;
      Wave.FileName := MMWaveOpenDialog1.FileName;
    end;
  finally
    (Self.FindComponent('PlayBtn' + IntToStr(Tag)) as TButton).Enabled :=
      not Wave.Empty;
  end;
end;

procedure TForm1.ResetBtnClick(Sender: TObject);
begin
  with FChannels[(Sender as TComponent).Tag] do
  begin
    Stop;
    Wave.FileName := '';
    (Self.FindComponent('PlayBtn' + IntToStr(Tag)) as TButton).Enabled := False;
  end;
end;

procedure TForm1.FreqSliderChange(Sender: TObject);
begin
  with FChannels[(Sender as TComponent).Tag] do
    Frequency := (Sender as TMMSlider).Position;
end;

procedure TForm1.VolSliderChange(Sender: TObject);
begin
  with FChannels[(Sender as TComponent).Tag] do
    Volume := (Sender as TMMSlider).Position
end;

procedure TForm1.PanWheelChange(Sender: TObject);
begin
  with FChannels[(Sender as TComponent).Tag] do
    Panning := (Sender as TMMWheel).Value
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  Index: Integer;
  Time: Integer;
begin
  for Index := 1 to 4 do with FChannels[Index] do
  begin
    if PWaveFormat <> nil
      then Time := Position div PWaveFormat.nAvgBytesPerSec
      else Time := 0;
    FTimeLabel[Index].Caption :=
      Format('%d:%2.2d', [Time div 60, Time mod 60]);
  end;
end;

procedure TForm1.StartBtnClick(Sender: TObject);
begin
  Mixer.Open;
  Timer1.Enabled := True;
  StopBtn.Enabled := True;
  StartBtn.Enabled := False;
end;

procedure TForm1.StopBtnClick(Sender: TObject);
begin
  Mixer.Close;
  Timer1.Enabled := False;
  StopBtn.Enabled := not True;
  StartBtn.Enabled := not False;
end;

end.
